#define NEED_CPU_REG_SHORTCUTS 1
#include "bochs.h"
#define LOG_THIS BX_CPU_THIS_PTR
#if BX_USE_CPU_SMF
#define this (BX_CPU(0))
#endif

void BX_CPU_C::EXEC_pop_O16AX(int seg,Bit8u* imm)
{
Bit16u arg0;


pop_16(&arg0);

AX=arg0;

}

void BX_CPU_C::EXEC_pop_O16BP(int seg,Bit8u* imm)
{
Bit16u arg0;


pop_16(&arg0);

BP=arg0;

}

void BX_CPU_C::EXEC_pop_O16BX(int seg,Bit8u* imm)
{
Bit16u arg0;


pop_16(&arg0);

BX=arg0;

}

void BX_CPU_C::EXEC_pop_O16CX(int seg,Bit8u* imm)
{
Bit16u arg0;


pop_16(&arg0);

CX=arg0;

}

void BX_CPU_C::EXEC_pop_O16DI(int seg,Bit8u* imm)
{
Bit16u arg0;


pop_16(&arg0);

DI=arg0;

}

void BX_CPU_C::EXEC_pop_O16DX(int seg,Bit8u* imm)
{
Bit16u arg0;


pop_16(&arg0);

DX=arg0;

}

void BX_CPU_C::EXEC_pop_O16SI(int seg,Bit8u* imm)
{
Bit16u arg0;


pop_16(&arg0);

SI=arg0;

}

void BX_CPU_C::EXEC_pop_O16SP(int seg,Bit8u* imm)
{
Bit16u arg0;


pop_16(&arg0);

SP=arg0;

}

void BX_CPU_C::EXEC_pop_O16dsD16(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit16u disp;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

pop_16(&arg0);
arg0_off=disp;

write_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O16dsD32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit32u disp;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

pop_16(&arg0);
arg0_off=disp;

write_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O16dsrm161(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit8u last;

last=*(imm-1);

pop_16(&arg0);
arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

write_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O16dsrm321(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit8u last;

last=*(imm-1);

pop_16(&arg0);
arg0_off = BX_READ_32BIT_REG(last&0x7);

write_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O16dsrm322D32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

pop_16(&arg0);
arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

write_virtual_word((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O16r1rm161D16(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

pop_16(&arg0);
arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

write_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O16r1rm161D8(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

pop_16(&arg0);
arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

write_virtual_word((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O16r2rm162(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit8u last;

last=*(imm-1);

pop_16(&arg0);
arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

write_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O16r2rm162D16(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

pop_16(&arg0);
arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

write_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O16r2rm162D8(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit16u arg0_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

pop_16(&arg0);
arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

write_virtual_word((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O16rarm321(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit8u last;

last=*(imm-1);

pop_16(&arg0);
arg0_off = BX_READ_32BIT_REG(last&0x7);

write_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O16rarm321D32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

pop_16(&arg0);
arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

write_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O16rarm321D8(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

pop_16(&arg0);
arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

write_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O16rarm323(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit8u last;

last=*(imm-1);

pop_16(&arg0);
arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

write_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O16rarm323D32(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

pop_16(&arg0);
arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

write_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O16rarm323D8(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit32u arg0_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

pop_16(&arg0);
arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

write_virtual_word((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O16regm(int seg,Bit8u* imm)
{
Bit16u arg0;
Bit8u last;

last=*(imm-1);

pop_16(&arg0);

BX_READ_16BIT_REG((last&0x7))=arg0;

}

void BX_CPU_C::EXEC_pop_O32EAX(int seg,Bit8u* imm)
{
Bit32u arg0;


pop_32(&arg0);

EAX=arg0;

}

void BX_CPU_C::EXEC_pop_O32EBP(int seg,Bit8u* imm)
{
Bit32u arg0;


pop_32(&arg0);

EBP=arg0;

}

void BX_CPU_C::EXEC_pop_O32EBX(int seg,Bit8u* imm)
{
Bit32u arg0;


pop_32(&arg0);

EBX=arg0;

}

void BX_CPU_C::EXEC_pop_O32ECX(int seg,Bit8u* imm)
{
Bit32u arg0;


pop_32(&arg0);

ECX=arg0;

}

void BX_CPU_C::EXEC_pop_O32EDI(int seg,Bit8u* imm)
{
Bit32u arg0;


pop_32(&arg0);

EDI=arg0;

}

void BX_CPU_C::EXEC_pop_O32EDX(int seg,Bit8u* imm)
{
Bit32u arg0;


pop_32(&arg0);

EDX=arg0;

}

void BX_CPU_C::EXEC_pop_O32ESI(int seg,Bit8u* imm)
{
Bit32u arg0;


pop_32(&arg0);

ESI=arg0;

}

void BX_CPU_C::EXEC_pop_O32ESP(int seg,Bit8u* imm)
{
Bit32u arg0;


pop_32(&arg0);

ESP=arg0;

}

void BX_CPU_C::EXEC_pop_O32dsD16(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit16u disp;

#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

pop_32(&arg0);
arg0_off=disp;

write_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O32dsD32(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit32u disp;

#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

pop_32(&arg0);
arg0_off=disp;

write_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O32dsrm161(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit8u last;

last=*(imm-1);

pop_32(&arg0);
arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]);

write_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O32dsrm321(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit8u last;

last=*(imm-1);

pop_32(&arg0);
arg0_off = BX_READ_32BIT_REG(last&0x7);

write_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O32dsrm322D32(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

pop_32(&arg0);
arg0_off = (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

write_virtual_dword((seg<0 ? BX_SEG_REG_DS : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O32r1rm161D16(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

pop_32(&arg0);
arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

write_virtual_dword((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O32r1rm161D8(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

pop_32(&arg0);
arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + disp;

write_virtual_dword((seg<0 ? ((last&0x7)!=0x6 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O32r2rm162(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit8u last;

last=*(imm-1);

pop_32(&arg0);
arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]);

write_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O32r2rm162D16(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit8u last;
Bit16u disp;

last=*(imm-1);
#if BX_NEED_WORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
#else
disp=*((Bit16u*)imm);
#endif

pop_32(&arg0);
arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

write_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O32r2rm162D8(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit16u arg0_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

pop_32(&arg0);
arg0_off = *(BX_CPU_THIS_PTR nemod_tbl1[last]) + *(BX_CPU_THIS_PTR nemod_tbl2[last]) + disp;

write_virtual_dword((seg<0 ? ((last&0x2)==0 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O32rarm321(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit8u last;

last=*(imm-1);

pop_32(&arg0);
arg0_off = BX_READ_32BIT_REG(last&0x7);

write_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O32rarm321D32(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

pop_32(&arg0);
arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

write_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O32rarm321D8(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

pop_32(&arg0);
arg0_off = BX_READ_32BIT_REG(last&0x7) + disp;

write_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O32rarm323(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit8u last;

last=*(imm-1);

pop_32(&arg0);
arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64));

write_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O32rarm323D32(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit8u last;
Bit32u disp;

last=*(imm-1);
#if BX_NEED_DWORD_ALIGN || BX_BIG_ENDIAN
disp=*imm;
disp|=(*(imm+1))<<8;
disp|=(*(imm+2))<<16;
disp|=(*(imm+3))<<24;
#else
disp=*((Bit32u*)imm);
#endif

pop_32(&arg0);
arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

write_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O32rarm323D8(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit32u arg0_off;
Bit8u last;
Bit8s disp;

last=*(imm-1);
disp=*imm;

pop_32(&arg0);
arg0_off = BX_READ_32BIT_REG(last&0x7) + (BX_READ_32BIT_REG((last&0x38)/8)<<((last&0xc0)/64)) + disp;

write_virtual_dword((seg<0 ? ((last&0x6)!=0x4 ? BX_SEG_REG_DS : BX_SEG_REG_SS) : seg),arg0_off,&arg0);

}

void BX_CPU_C::EXEC_pop_O32regm(int seg,Bit8u* imm)
{
Bit32u arg0;
Bit8u last;

last=*(imm-1);

pop_32(&arg0);

BX_READ_32BIT_REG((last&0x7))=arg0;

}
